<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('mobile_number', 'id_card');

    public function EndPoints()
    {
        return $this->hasMany('EndPoint');
    }

    public function Loans()
    {
        return $this->hasMany('Loan');
    }

    public function Documents()
    {
        return $this->hasMany('Document');
    }

    public function Messages()
    {
        return $this->hasMany('Message');
    }

}